import bpy
from bpy.types import PropertyGroup, Collection, World
from bpy.props import PointerProperty, StringProperty
from ..ui.props_ui import UiProps
from ..lists.pointers_all_lists import AllLists
from ..fluid_settings.props_fluid_settings import FluidLab_PG_FluidSettings
from ..rendering.rendering import FluidLab_PG_Rendering
from ..fluid_forces import FluidLab_PG_FluidForces
from ..shading import FluidLab_PG_Shading
from ..fluid_presets import FluidLab_PG_FluidPresets
from ..dynamic_paint import FluidLab_PG_Dynamic_Paint


class FluidLabPointers(PropertyGroup):
    
    """ context.scene.fluidlab.x """

    root_collection: PointerProperty(type=Collection)

    ui: PointerProperty(type=UiProps)
    
    lists: PointerProperty(type=AllLists)
    
    fluid_settings: PointerProperty(type=FluidLab_PG_FluidSettings)

    rendering: PointerProperty(type=FluidLab_PG_Rendering)
    last_world: PointerProperty(type=World)

    fluid_forces: PointerProperty(type=FluidLab_PG_FluidForces)

    fluid_presets: PointerProperty(type=FluidLab_PG_FluidPresets)

    dynamic_paint: PointerProperty(type=FluidLab_PG_Dynamic_Paint)
    
    # Shaders thumbnails:
    shader_props: PointerProperty(type=FluidLab_PG_Shading)

    # Last Bake info:
    last_bake_time: StringProperty(default="")